#ifndef _lf_fms_settings_h_
#define _lf_fms_settings_h_

#include "db.h"
#include "lf_db.h"

/*
 * Settings used by the FMS.  These are defined here because there are 
 * standalone tools (e.g. fm_settings) which will manipulate these settings.
 *
 * Settings come in different types:
 * 	parameters
 * 	event notification registrations
 */

enum lf_fms_param_type {
  LF_FPT_INTEGER,		/* an integer setting */
  LF_FPT_STRING,		/* a string setting */
  LF_FPT_COUNT			/* number of types */
};

typedef char *__charstar;	/* need a one-word typedef for "char *" */

/*
 * This defines a parameter
 */
struct lf_fms_param_def {
  char *name;			/* parameter name */
  enum lf_fms_param_type type;	/* type */
  char *dflt_value;		/* default value */
  char *units_singular; /* units (if applicable) */
  char *units_plural;
};

#define LF_TABLE_FMS_SETTINGS "fms_settings"
enum {
  LF_TABLE_FMS_SETTINGS_PARAM,
  LF_TABLE_FMS_SETTINGS_VALUE,
  LF_TABLE_FMS_SETTINGS_NUMCOLS
};
#ifdef _LF_DEFINE_TABLES_
static struct lf_col_desc lf_table_fms_settings_cols[] = {
  { "parameter", DBD_STR },
  { "value", DBD_STR }
};
#endif

/*
 * prototypes
 */
db_table_ptr_t lf_open_fms_settings_table(db_database_ptr_t dbp, int **colids);

#endif /* _lf_fms_settings.h_ */
